/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.CollectionWrapper;
import org.codefilarete.tool.collection.FilteringIterator;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CollectionWrapperTest {
    private static final Set<Method> EQUALS_HASHCODE_METHODS = new HashSet<Method>();

    CollectionWrapperTest() {
    }

    @Test
    void methodsInvokeDelegateMethods() {
        Collection delegate = (Collection)Mockito.mock(Collection.class);
        CollectionWrapper testInstance = new CollectionWrapper(delegate);
        List collectionClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(Collection.class, null)));
        collectionClassInheritance.add(0, Collection.class);
        MethodIterator methodInHierarchyIterator = new MethodIterator(collectionClassInheritance.iterator());
        FilteringIterator nonMutatingMethodsIterator = new FilteringIterator((Iterator)methodInHierarchyIterator, m -> !EQUALS_HASHCODE_METHODS.contains(m));
        Iterable methods = () -> nonMutatingMethodsIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                if (method.equals(Collection.class.getMethod("stream", new Class[0])) || method.equals(Collection.class.getMethod("parallelStream", new Class[0]))) {
                    invocationResult = null;
                }
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new Collection[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(20);
    }

    static {
        try {
            EQUALS_HASHCODE_METHODS.add(Collection.class.getMethod("equals", Object.class));
            EQUALS_HASHCODE_METHODS.add(Collection.class.getMethod("hashCode", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

